---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-グローバルエラーページ (Global Error)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/builtin/global-error.tsx` L1 - 'use client'ディレクティブ
- E-02: `packages/next/src/client/components/builtin/global-error.tsx` L6-8 - GlobalErrorComponent型
- E-03: `packages/next/src/client/components/builtin/global-error.tsx` L10-77 - DefaultGlobalError関数
- E-04: `packages/next/src/client/components/builtin/global-error.tsx` L11-12 - digest/isServerError判定
- E-05: `packages/next/src/client/components/builtin/global-error.tsx` L16-22 - title/message/hint設定
- E-06: `packages/next/src/client/components/builtin/global-error.tsx` L25 - html id属性
- E-07: `packages/next/src/client/components/builtin/global-error.tsx` L30 - HandleISRError配置
- E-08: `packages/next/src/client/components/builtin/global-error.tsx` L44-47 - Reload pageボタン
- E-09: `packages/next/src/client/components/builtin/global-error.tsx` L48-61 - Go backボタン
- E-10: `packages/next/src/client/components/builtin/global-error.tsx` L64-70 - digest表示
- E-11: `packages/next/src/client/components/builtin/error-styles.tsx` L3-86 - errorStyles
- E-12: `packages/next/src/client/components/builtin/error-styles.tsx` L88-124 - errorThemeCss
- E-13: `packages/next/src/client/components/builtin/error-styles.tsx` L126-152 - ErrorIcon
- E-14: `packages/next/src/client/components/handle-isr-error.tsx` L1-23 - HandleISRError
- E-15: `docs/code-to-docs/画面一覧/画面一覧.csv` L7 - 画面情報定義
- E-16: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L17-19 - 関連機能情報
- E-17: `docs/code-to-docs/画面一覧/画面遷移図.md` L43-45 - 遷移図

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 'use client'ディレクティブが設定されたClient Component | E-01 | ○ |
| C-02 | error.digestの有無でサーバー/クライアントエラーを判別 | E-04 | ○ |
| C-03 | サーバーエラー時「This page failed to load」を表示 | E-05 | ○ |
| C-04 | クライアントエラー時「This page crashed」を表示 | E-05 | ○ |
| C-05 | サーバーエラー時のメッセージ「Something went wrong...」 | E-05 | ○ |
| C-06 | クライアントエラー時のメッセージ「An error occurred...」 | E-05 | ○ |
| C-07 | サーバーエラー時のヒント「If this keeps happening...」 | E-05 | ○ |
| C-08 | クライアントエラー時のヒント「Reloading usually fixes this.」 | E-03 | ○ |
| C-09 | Reload pageボタンがform submitで実装 | E-08 | ○ |
| C-10 | Go backボタンはクライアントエラー時のみ表示 | E-09 | ○ |
| C-11 | Go backはhistory.back()またはトップ遷移 | E-09 | ○ |
| C-12 | digest存在時にError reference表示 | E-10 | ○ |
| C-13 | html要素にid="__next_error__"が設定 | E-06 | ○ |
| C-14 | HandleISRErrorコンポーネントでISRエラー処理 | E-07, E-14 | ○ |
| C-15 | ISR静的生成中はエラー再スロー | E-14 | ○ |
| C-16 | GlobalErrorComponent型がエクスポート | E-02 | ○ |
| C-17 | errorThemeCssでCSS変数によるダークモード対応 | E-12 | ○ |
| C-18 | ErrorIconは40x40のSVGで赤色(#dc2626) | E-13 | ○ |
| C-19 | App Routerで使用 | E-15 | ○ |
| C-20 | エラーハンドリングが主機能、ISRがAPI連携 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] サーバーエラー/クライアントエラーの判別ロジック（digest有無）が正確か確認
- [ ] Go backボタンのhistory.length判定ロジックが正確か確認
- [ ] HandleISRErrorのISR時の挙動が正確か確認
